use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-90480  66461
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_ReplicatePanelDatabase]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_ReplicatePanelDatabase]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_ReplicatePanelDatabase]
AS
BEGIN
  SET NOCOUNT ON
  DECLARE @surveyDatabase nvarchar(64) = DB_NAME()
  DECLARE @clientId int = dbo.GetClientId(@surveyDatabase) 
  DECLARE @clientIdString nvarchar(8) = CONVERT(nvarchar, @clientId)
  DECLARE @panelDatabase nvarchar(40) = ''A4Panel_Client_'' + @clientIdString
  DECLARE @surveyId int
  DECLARE @surveySchema nvarchar(40)
  DECLARE @synchronizationVersion int 
  DECLARE @sqlcmd nvarchar(max) 

  -- Get last version from DB
  SELECT TOP 1 @synchronizationVersion = [Version] FROM [ChangeTrackingVersions] ORDER BY [Version] DESC
 
  IF @synchronizationVersion < CHANGE_TRACKING_CURRENT_VERSION()
  BEGIN 
   BEGIN TRY
    SET TRANSACTION ISOLATION LEVEL SNAPSHOT;
    BEGIN TRAN

    PRINT ''Updating version: '' + CAST(@synchronizationVersion AS NVARCHAR)   

    IF (SELECT COUNT(*) FROM sys.change_tracking_tables WHERE min_valid_version > @synchronizationVersion AND min_valid_version > begin_version) > 0
    BEGIN
   RAISERROR (N''Synchronization version is too old - Call A4S_sp_ResetPanelDatabase to reset all the data.'', 16, -1)
    END
    ELSE
    BEGIN
  -- Schemas
  DECLARE surveyCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY
  FOR SELECT [SurveyId] FROM A4S_fn_GetPanelSurveyIds();
    
  OPEN surveyCursor;
  FETCH NEXT FROM surveyCursor INTO @surveyId;
  WHILE @@FETCH_STATUS = 0 BEGIN
   DECLARE @surveyIdString nvarchar(10) = CONVERT(nvarchar, @surveyId);
   SET @surveySchema = ''Survey_'' + @clientIdString + ''_'' + @surveyIdString;

	CREATE TABLE #Respondent_CT (
		[ResRespondent] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL,
		SYS_CHANGE_COLUMNS VARBINARY(4100) NULL
	);

    SET @sqlcmd = N''
	INSERT INTO #Respondent_CT
	SELECT ct.[ResRespondent], ct.SYS_CHANGE_OPERATION, ct.SYS_CHANGE_COLUMNS
    FROM CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Respondent], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;

	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		INSERT INTO ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] ([SurveyId], [PanelistId], [RespondentId], [RespondentActive], [RespondentOnline])
		SELECT @surveyId, r.[panelistId], r.[ResRespondent], r.[ResActive], r.[ResOnline]
		FROM ['' + @surveySchema + ''].[Respondent] r 
		INNER JOIN ['' + @panelDatabase +  ''].[dbo].[Panelists] p ON r.[panelistId] = p.[Id]
		INNER JOIN #Respondent_CT AS ct
			ON r.[ResRespondent] = ct.[ResRespondent]
			AND ct.SYS_CHANGE_OPERATION = ''''I''''
		LEFT JOIN ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] pr
			ON pr.[SurveyId] = @surveyId
			AND r.[panelistId] = pr.[PanelistId]
			AND r.[ResRespondent] = pr.[RespondentId]
		WHERE pr.[SurveyId] IS NULL;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;

		SET @sqlcmd = N''
		DECLARE @ResActiveColumnId int = COLUMNPROPERTY(OBJECT_ID(''''['' + @surveySchema + ''].[Respondent]''''),''''ResActive'''', ''''ColumnId'''');
		DECLARE @ResOnlineColumnId int = COLUMNPROPERTY(OBJECT_ID(''''['' + @surveySchema + ''].[Respondent]''''),''''ResOnline'''', ''''ColumnId'''');

		UPDATE pr
		SET pr.[RespondentActive] = r.[ResActive], pr.[RespondentOnline] = r.[ResOnline]
		FROM ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] AS pr
		INNER JOIN ['' + @surveySchema + ''].[Respondent] AS r ON pr.[RespondentId] = r.[ResRespondent]
		INNER JOIN #Respondent_CT AS ct
			ON r.[ResRespondent] = ct.[ResRespondent]
			AND ct.SYS_CHANGE_OPERATION = ''''U''''
			AND (
				CHANGE_TRACKING_IS_COLUMN_IN_MASK(@ResActiveColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@ResOnlineColumnId, ct.SYS_CHANGE_COLUMNS) = 1
			)
		WHERE pr.[SurveyId] = @surveyId;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;

		SET @sqlcmd = N''
		DELETE pr
		FROM ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] AS pr
		INNER JOIN #Respondent_CT AS ct
			ON pr.[RespondentId] = ct.[ResRespondent]
			AND ct.SYS_CHANGE_OPERATION = ''''D''''
		WHERE pr.[SurveyId] = @surveyId;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;
	END

	DROP TABLE #Respondent_CT;

	CREATE TABLE #Response_CT (
		[RpsRespondent] INT NOT NULL,
		[RpsQuestion] NVARCHAR(255) NOT NULL,
		[RpsMatrix] INT NOT NULL,
		[RpsMention] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL,
		SYS_CHANGE_COLUMNS VARBINARY(4100) NULL
	);

    SET @sqlcmd = N''
	INSERT INTO #Response_CT
    SELECT ct.[RpsRespondent], ct.[RpsQuestion], ct.[RpsMatrix], ct.[RpsMention], ct.SYS_CHANGE_OPERATION, ct.SYS_CHANGE_COLUMNS
    FROM CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Response], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;

	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		INSERT INTO ['' + @panelDatabase + ''].[dbo].[PanelistSurveyResponses] ([SurveyId], [RespondentId], [PanelistId], [VariableId], [VariableName], [Matrix], [Mention], [Content])
		SELECT @surveyId, r.[RpsRespondent], pr.[PanelistId], r.[RpsVariableId], r.[RpsQuestion], r.[RpsMatrix], r.[RpsMention], r.[RpsContent]
		FROM ['' + @surveySchema + ''].[Response] AS r
		INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr
			ON pr.[SurveyId] = @surveyId
			AND r.[RpsRespondent] = pr.[RespondentId]
		INNER JOIN #Response_CT AS ct
			ON r.[RpsRespondent] = ct.[RpsRespondent]
			AND r.[RpsQuestion] = ct.[RpsQuestion]
			AND r.[RpsMatrix] = ct.[RpsMatrix]
			AND r.[RpsMention] = ct.[RpsMention]
			AND ct.SYS_CHANGE_OPERATION = ''''I'''';''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;

		SET @sqlcmd = N''
		DECLARE @RpsContentColumnId int = COLUMNPROPERTY(OBJECT_ID(''''['' + @surveySchema + ''].[Response]''''),''''RpsContent'''', ''''ColumnId'''');

		UPDATE psr
		SET psr.[Content] = r.[RpsContent]
		FROM ['' + @panelDatabase + ''].[dbo].[PanelistSurveyResponses] AS psr
		INNER JOIN ['' + @surveySchema + ''].[Response] AS r 
			ON psr.[RespondentId] = r.[RpsRespondent]
			AND psr.[VariableName] = r.[RpsQuestion]
			AND psr.[Matrix] = r.[RpsMatrix]
			AND psr.[Mention] = r.[RpsMention]
		INNER JOIN #Response_CT AS ct
			ON r.[RpsRespondent] = ct.[RpsRespondent]
			AND r.[RpsQuestion] = ct.[RpsQuestion]
			AND r.[RpsMatrix] = ct.[RpsMatrix]
			AND r.[RpsMention] = ct.[RpsMention]
			AND ct.SYS_CHANGE_OPERATION = ''''U''''
			AND CHANGE_TRACKING_IS_COLUMN_IN_MASK(@RpsContentColumnId, ct.SYS_CHANGE_COLUMNS) = 1
		WHERE psr.[SurveyId] = @surveyId;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;

		SET @sqlcmd = N''
		DELETE psr
		FROM ['' + @panelDatabase + ''].[dbo].[PanelistSurveyResponses] AS psr
		INNER JOIN #Response_CT AS ct
			ON psr.[RespondentId] = ct.[RpsRespondent]
			AND psr.[VariableName] = ct.[RpsQuestion]
			AND psr.[Matrix] = ct.[RpsMatrix]
			AND psr.[Mention] = ct.[RpsMention]
			AND ct.SYS_CHANGE_OPERATION = ''''D''''
		WHERE psr.[SurveyId] = @surveyId;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;
	END
	
	DROP TABLE #Response_CT;

	CREATE TABLE #Historic_CT (
		[HisRespondent] INT NOT NULL,
		[HisCallNumber] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL,
		SYS_CHANGE_COLUMNS VARBINARY(4100) NULL
	);

    SET @sqlcmd = N''
	INSERT INTO #Historic_CT
    SELECT ct.[HisRespondent], ct.[HisCallNumber], ct.SYS_CHANGE_OPERATION, ct.SYS_CHANGE_COLUMNS
    FROM CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Historic], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;

	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		DECLARE @surveyActivityHistory TABLE (
			[Id] INT,
			[Index] INT,
			[DispositionCode] TINYINT
		);

		MERGE INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS destination
		USING (
			SELECT
				pr.[PanelistId],
				h.[HisRespondent] AS [RespondentId],
				h.[HisCallDate] AS [DateTime],
				h.[HisCallNumber] AS [Index],
				h.[HisResult] AS [DispositionCode]
			FROM ['' + @surveySchema + ''].[Historic] AS h
			INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr
				ON pr.[SurveyId] = @surveyId
				AND h.[HisRespondent] = pr.[RespondentId]
			INNER JOIN #Historic_CT AS ct
				ON h.[HisRespondent] = ct.[HisRespondent]
				AND h.[HisCallNumber] = ct.[HisCallNumber]
				AND ct.SYS_CHANGE_OPERATION = ''''I''''
			WHERE NOT EXISTS (
				SELECT 1
				FROM ['' + @panelDatabase +  ''].[dbo].[ActivityHistories] ah
				INNER JOIN ['' + @panelDatabase +  ''].[dbo].[ActivityHistories_SurveyActivityHistory] sah ON ah.[Id] = sah.[Id] AND h.[HisCallNumber] = sah.[Index]
				WHERE ah.[SurveyId] = @surveyId AND h.[HisRespondent] = ah.[RespondentId]
			)
		) AS source
		ON 1 = 0 -- never match
		WHEN NOT MATCHED THEN
			INSERT ([PanelistId], [SurveyId], [RespondentId], [DateTime])
			VALUES (source.[PanelistId], @surveyId, source.[RespondentId], source.[DateTime])
			OUTPUT inserted.[Id], source.[Index], source.[DispositionCode]
			INTO @surveyActivityHistory ([Id], [Index], [DispositionCode]);

		INSERT INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] ([Id], [Index], [DispositionCode])
		SELECT [Id], [Index], [DispositionCode]
		FROM @surveyActivityHistory;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;

		SET @sqlcmd = N''
		DECLARE @HisResultColumnId int = COLUMNPROPERTY(OBJECT_ID(''''['' + @surveySchema + ''].[Historic]''''),''''HisResult'''', ''''ColumnId'''');

		UPDATE sah
		SET sah.[DispositionCode] = h.[HisResult]
		FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS ah
		INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] AS sah ON ah.[Id] = sah.[Id]
		INNER JOIN ['' + @surveySchema + ''].[Historic] AS h
			ON ah.[RespondentId] = h.[HisRespondent]
			AND sah.[Index] = h.[HisCallNumber]
		INNER JOIN #Historic_CT AS ct
			ON h.[HisRespondent] = ct.[HisRespondent]
			AND h.[HisCallNumber] = ct.[HisCallNumber]
			AND ct.SYS_CHANGE_OPERATION = ''''U''''
			AND CHANGE_TRACKING_IS_COLUMN_IN_MASK(@HisResultColumnId, ct.SYS_CHANGE_COLUMNS) = 1
		WHERE ah.[SurveyId] = @surveyId;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;

		SET @sqlcmd = N''
		DELETE ah
		FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS ah
		INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] AS sah ON ah.[Id] = sah.[Id]
		INNER JOIN #Historic_CT AS ct
			ON ah.[RespondentId] = ct.[HisRespondent]
			AND sah.[Index] = ct.[HisCallNumber]
			AND ct.SYS_CHANGE_OPERATION = ''''D''''
		WHERE ah.[SurveyId] = @surveyId;''
		EXEC sp_executesql @sqlcmd, N''@surveyId int'', @surveyId = @surveyId;
	END
	
    DROP TABLE #Historic_CT;
     
   FETCH NEXT FROM surveyCursor INTO @surveyId;
  END
  CLOSE surveyCursor;
  DEALLOCATE surveyCursor;

	CREATE TABLE #Users_CT (
		[Id] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL,
		SYS_CHANGE_COLUMNS VARBINARY(4100) NULL
	);
	
    SET @sqlcmd = N''
	INSERT INTO #Users_CT
	SELECT ct.[Id], ct.SYS_CHANGE_OPERATION, ct.SYS_CHANGE_COLUMNS
	FROM CHANGETABLE(CHANGES [dbo].[Users], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;

	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		INSERT INTO ['' + @panelDatabase + ''].[dbo].[Users] ([Id], [UserName], [FirstName], [LastName], [DisplayName])
		SELECT u.[Id], u.[UserName], u.[FirstName], u.[LastName], u.[FirstName] + '''' '''' + u.[LastName]
		FROM [dbo].[Users] AS u
		INNER JOIN #Users_CT AS ct
			ON u.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''I'''';''
		EXEC sp_executesql @sqlcmd;

		SET @sqlcmd = N''
		DECLARE @UserNameColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[Users]''''),''''UserName'''', ''''ColumnId'''');
		DECLARE @FirstNameColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[Users]''''),''''FirstName'''', ''''ColumnId'''');
		DECLARE @LastNameColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[Users]''''),''''LastName'''', ''''ColumnId'''');

		UPDATE pu
		SET pu.[UserName] = u.[UserName],
			pu.[FirstName] = u.[FirstName],
			pu.[LastName] = u.[LastName],
			pu.[DisplayName] = u.[FirstName] + '''' '''' + u.[LastName]
		FROM ['' + @panelDatabase + ''].[dbo].[Users] AS pu
		INNER JOIN [dbo].[Users] AS u ON pu.[Id] = u.[Id]
		INNER JOIN #Users_CT AS ct
			ON u.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''U''''
			AND (
				CHANGE_TRACKING_IS_COLUMN_IN_MASK(@UserNameColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@FirstNameColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@LastNameColumnId, ct.SYS_CHANGE_COLUMNS) = 1
			);''
		EXEC sp_executesql @sqlcmd;

		SET @sqlcmd = N''
		DELETE pu
		FROM ['' + @panelDatabase + ''].[dbo].[Users] AS pu 
		INNER JOIN #Users_CT AS ct
			ON pu.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''D'''';''
		EXEC sp_executesql @sqlcmd;
	END
	
	DROP TABLE #Users_CT;

    CREATE TABLE #VEM_EmailInvitation_CT (
		[Id] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL,
		SYS_CHANGE_COLUMNS VARBINARY(4100) NULL
	);
	
    SET @sqlcmd = N''
	INSERT INTO #VEM_EmailInvitation_CT
    SELECT ct.[Id], ct.SYS_CHANGE_OPERATION, ct.SYS_CHANGE_COLUMNS
    FROM CHANGETABLE(CHANGES [dbo].[VEM_EmailInvitation], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;
	
	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		INSERT INTO ['' + @panelDatabase + ''].[dbo].[EmailInvitations] ([Id], [SurveyId], [Name], [TemplateId], [TemplateName], [SendDateTime], [Status])
		SELECT ei.[Id], ei.[ProjectId], ei.[Name], ei.[DefaultTemplateId], ei.[DefaultTemplateName], ei.[SendDateTime], ei.[Status]
		FROM [dbo].VEM_EmailInvitation AS ei
		INNER JOIN #VEM_EmailInvitation_CT AS ct
			ON ei.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''I'''';''
		EXEC sp_executesql @sqlcmd;

		SET @sqlcmd = N''
		DECLARE @NameColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[VEM_EmailInvitation]''''),''''Name'''', ''''ColumnId'''');
		DECLARE @DefaultTemplateIdColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[VEM_EmailInvitation]''''),''''DefaultTemplateId'''', ''''ColumnId'''');
		DECLARE @DefaultTemplateNameColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[VEM_EmailInvitation]''''),''''DefaultTemplateName'''', ''''ColumnId'''');
		DECLARE @SendDateTimeColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[VEM_EmailInvitation]''''),''''SendDateTime'''', ''''ColumnId'''');
		DECLARE @StatusColumnId int = COLUMNPROPERTY(OBJECT_ID(''''[dbo].[VEM_EmailInvitation]''''),''''Status'''', ''''ColumnId'''');
    
		UPDATE pei
		SET pei.[Name] = ei.[Name],
			pei.[TemplateId] = ei.[DefaultTemplateId],
			pei.[TemplateName] = ei.[DefaultTemplateName],
			pei.[SendDateTime] = ei.[SendDateTime],
			pei.[Status] = ei.[Status]
		FROM ['' + @panelDatabase + ''].[dbo].[EmailInvitations] AS pei
		INNER JOIN [dbo].[VEM_EmailInvitation] AS ei ON pei.[Id] = ei.[Id]
		INNER JOIN #VEM_EmailInvitation_CT AS ct
			ON ei.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''U''''
			AND (
				CHANGE_TRACKING_IS_COLUMN_IN_MASK(@NameColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@DefaultTemplateIdColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@DefaultTemplateNameColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@SendDateTimeColumnId, ct.SYS_CHANGE_COLUMNS) = 1
				OR CHANGE_TRACKING_IS_COLUMN_IN_MASK(@StatusColumnId, ct.SYS_CHANGE_COLUMNS) = 1
			);''
		EXEC sp_executesql @sqlcmd;

		SET @sqlcmd = N''
		DELETE pei
		FROM ['' + @panelDatabase + ''].[dbo].[EmailInvitations] AS pei
		INNER JOIN #VEM_EmailInvitation_CT AS ct
			ON pei.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''D'''';''
		EXEC sp_executesql @sqlcmd;
	END
	
	DROP TABLE #VEM_EmailInvitation_CT;
	
	CREATE TABLE #VEM_InvitationHistory_CT (
		[Id] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL
	);
	
    SET @sqlcmd = N''
	INSERT INTO #VEM_InvitationHistory_CT
	SELECT ct.[Id], ct.SYS_CHANGE_OPERATION
    FROM CHANGETABLE(CHANGES [dbo].[VEM_InvitationHistory], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;

	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		DECLARE @emailActivityHistory TABLE (
			[Id] INT,
			[EmailInvitationId] INT,
			[EmailHistoryId] INT,
			[EmailInvitationStatus] TINYINT,
			[TemplateId] INT
		)

		MERGE INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS destination
		USING (
			SELECT
				pr.[PanelistId],
				i.[ProjectId] AS [SurveyId],
				h.[RespondentId],
				h.[TimeStampGMT] AS [DateTime],
				i.[Id] AS [EmailInvitationId],
				h.[Id] AS [EmailHistoryId],
				CASE
					WHEN h.[Status] = ''''Sent'''' THEN 1
					WHEN h.[Status] = ''''Started'''' THEN 2
					WHEN h.[Status] = ''''Bounced''''THEN 3
					WHEN h.[Status] = ''''Completed'''' THEN 4
					ELSE 0
				END AS [EmailInvitationStatus],
				i.[DefaultTemplateId] AS [TemplateId]
			FROM [dbo].[VEM_InvitationHistory] h
			INNER JOIN [dbo].[VEM_EmailInvitation] i on h.[InvitationId] = i.[Id]
			INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr ON i.[ProjectId] = pr.[SurveyId] AND h.[RespondentId] = pr.[RespondentId]
			INNER JOIN #VEM_InvitationHistory_CT AS ct
				ON h.[Id] = ct.[Id]
				AND ct.SYS_CHANGE_OPERATION = ''''I''''
		) AS source
		ON 1 = 0 -- never match
		WHEN NOT MATCHED THEN
		INSERT ([PanelistId], [SurveyId], [RespondentId], [DateTime])
		VALUES (source.[PanelistId], source.[SurveyId], source.[RespondentId], source.[DateTime])
		OUTPUT inserted.[Id], source.[EmailInvitationId], source.[EmailHistoryId], source.[EmailInvitationStatus], source.[TemplateId]
		INTO @emailActivityHistory;

		INSERT INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories_EmailActivityHistory] ([Id], [EmailInvitationId], [EmailHistoryId], [EmailInvitationStatus], [TemplateId])
		SELECT [Id], [EmailInvitationId], [EmailHistoryId], [EmailInvitationStatus], [TemplateId]
		FROM @emailActivityHistory;''
		EXEC sp_executesql @sqlcmd;

		SET @sqlcmd = N''
		DELETE ah
		FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS ah
		INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_EmailActivityHistory] AS eah ON ah.[Id] = eah.[Id]
		INNER JOIN #VEM_InvitationHistory_CT AS ct
			ON eah.[EmailHistoryId] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''D'''';''
		EXEC sp_executesql @sqlcmd;

	END
	
	DROP TABLE #VEM_InvitationHistory_CT;
	
	CREATE TABLE #Distributions_SMS_History_CT (
		[Id] INT NOT NULL,
		SYS_CHANGE_OPERATION NCHAR(1) NOT NULL
	);
	
    SET @sqlcmd = N''
	INSERT INTO #Distributions_SMS_History_CT
    SELECT ct.[Id], ct.SYS_CHANGE_OPERATION
    FROM CHANGETABLE(CHANGES [dbo].[Distributions_SMS_History], @synchronizationVersion) AS ct;''
    EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion;

	IF @@ROWCOUNT > 0
	BEGIN
		SET @sqlcmd = N''
		DECLARE @smsActivityHistory TABLE (
			[Id] INT,
			[SmsInvitationId] INT,
			[SmsInvitationStatus] TINYINT
		)

		MERGE INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS destination
		USING (
			SELECT
				pr.[PanelistId],
				d.[SurveyId],
				h.[RespondentId],
				h.[TimeStamp] AS [DateTime],
				d.[Id] AS [SmsInvitationId],
				h.[Status] AS [SmsInvitationStatus]
			FROM [dbo].[Distributions_SMS_History] h
			INNER JOIN [dbo].[Distributions] d ON h.[DistributionId] = d.[Id]
			INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr
				ON d.[SurveyId] = pr.[SurveyId]
				AND h.[RespondentId] = pr.[RespondentId]
			INNER JOIN #Distributions_SMS_History_CT AS ct
				ON h.[Id] = ct.[Id]
				AND ct.SYS_CHANGE_OPERATION = ''''I''''
		) AS source
		ON 1 = 0 -- never match
		WHEN NOT MATCHED THEN
		INSERT ([PanelistId], [SurveyId], [RespondentId], [DateTime])
		VALUES (source.[PanelistId], source.[SurveyId], source.[RespondentId], source.[DateTime])
		OUTPUT inserted.[Id], source.[SmsInvitationId], source.[SmsInvitationStatus]
		INTO @smsActivityHistory;

		INSERT INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SmsActivityHistory] ([Id], [SmsInvitationId], [SmsInvitationStatus])
		SELECT [Id], [SmsInvitationId], [SmsInvitationStatus]
		FROM @smsActivityHistory;''
		EXEC sp_executesql @sqlcmd;

		SET @sqlcmd = N''
		DELETE ah
		FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS ah 
		INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SmsActivityHistory] AS sah ON ah.[Id] = sah.[Id]
		INNER JOIN #Distributions_SMS_History_CT AS ct
			ON sah.[Id] = ct.[Id]
			AND ct.SYS_CHANGE_OPERATION = ''''D'''';''
		EXEC sp_executesql @sqlcmd;
	END
		
	DROP TABLE #Distributions_SMS_History_CT;
    END

    UPDATE [dbo].[ChangeTrackingVersions] SET [Updated] = GETDATE() WHERE [Version] = @synchronizationVersion
    INSERT INTO [dbo].[ChangeTrackingVersions] ([Version]) VALUES (CHANGE_TRACKING_CURRENT_VERSION())

    COMMIT TRAN
   END TRY
   BEGIN CATCH
    IF @@TRANCOUNT > 0 ROLLBACK TRAN

    DECLARE @ErrorMessage NVARCHAR(4000);
    DECLARE @ErrorSeverity INT;
    DECLARE @ErrorState INT;
    SELECT @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();

    UPDATE [dbo].[ChangeTrackingVersions] SET [ErrorMessage] = @ErrorMessage WHERE [Version] = @synchronizationVersion      
   
    RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState);
   END CATCH
  END
  ELSE
  BEGIN
   PRINT ''Panel database is already up to date''
  END
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone